﻿<?xml version="1.0" encoding="UTF-8"?>

<!-- 調理指示 単品伝票用 スタイルシート (TM-T90 縦置き用) -->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns="http://www.nrf-arts.org/UnifiedPOS/POSPrinter/" xmlns:ofsc="http://www.ofsc.org/namespace/Device/2008/11" xmlns:ixr="http://www.nrf-arts.org/IXRetail/namespace/" version="1.0">
  <xsl:output method="xml" encoding="utf-8"/>

  <xsl:template match="/">
    <s:Envelope xmlns:s="http://schemas.xmlsoap.org/soap/envelope/">
      <s:Body>
        <POSPrinter MajorVersion="1">
          <ARTSHeader>
            <MessageID/>
          </ARTSHeader>
          <POSPrinterBody>
            <xsl:apply-templates select=".//ixr:POSLog"/>
          </POSPrinterBody>
        </POSPrinter>
      </s:Body>
    </s:Envelope>
  </xsl:template>

  <xsl:template match="ixr:POSLog" xml:space="preserve">

    <!-- 初期設定 -->
    <Open/>
    <Claim>
      <Timeout>3000</Timeout>
    </Claim>
    <SetDeviceEnabled>
      <DeviceEnabled>true</DeviceEnabled>
    </SetDeviceEnabled>
    <SetMapMode>
      <MapMode>Dots</MapMode>
    </SetMapMode>
    <SetRecLetterQuality>
      <RecLetterQuality>true</RecLetterQuality>
    </SetRecLetterQuality>
    <TransactionPrint>
      <Station>Receipt</Station>
      <Control>Transaction</Control>
    </TransactionPrint>

    <!-- 180度回転モードの設定 -->
    <RotatePrint>
      <Station>Receipt</Station>
      <Rotation>259</Rotation>
    </RotatePrint>

    <!-- 白伝用 カットコマンド -->
    <PrintNormal>
      <Station>Receipt</Station>
      <Data>\u001b|100fP</Data>
    </PrintNormal>

    <!-- 印刷データ作成 -->
    <xsl:apply-templates select="ixr:Transaction/ixr:CustomerOrderTransaction/ixr:LineItem"/>

    <!-- 最後のカットを実行するため112ドットフィード。
         また視認性向上のため、80ドット(10mm)フィード -->

    <!-- 180度回転モード終了 -->
    <RotatePrint>
      <Station>Receipt</Station>
      <Rotation>1</Rotation>
    </RotatePrint>

    <!-- ブザー鳴呼 -->

    <TransactionPrint>
      <Station>Receipt</Station>
      <Control>Normal</Control>
    </TransactionPrint>
    <SetDeviceEnabled>
      <DeviceEnabled>false</DeviceEnabled>
    </SetDeviceEnabled>
    <Release/>
    <Close/>

  </xsl:template>

  <xsl:template match="ixr:Transaction/ixr:CustomerOrderTransaction/ixr:LineItem" xml:space="preserve">

    <!-- シーケンス番号を5桁の文字列に成形 -->
    <xsl:variable name="SequenceNumber" select="format-number(//ixr:SequenceNumber, '00000')"/>
    <!-- 注文時間を抽出(4桁の文字列) -->
    <xsl:variable name="POSLogTime" select="substring(//ixr:POSLogDateTime, 12, 5)"/>
    <!-- テーブル番号を5桁の文字列に成形 -->
    <xsl:variable name="Temp1" select="//ixr:TableID"/>
    <xsl:variable name="TableID" select="concat(substring('     ', 1, 5 - string-length($Temp1)), $Temp1)"/>

    <!-- 180度回転で印刷するため、下のデータから指定していく -->

    <!-- 伝票を20mmにするため、2mm(16ドット)の改行 -->

    <!-- シーケンス番号、人数、注文担当者、注文時間を印刷。-->
    <PrintNormal>
      <Station>Receipt</Station>
      <Data>        <xsl:value-of select="$SequenceNumber"/>    <xsl:value-of select="//ixr:PartySize"/>名    <xsl:value-of select="//ixr:OperatorID"/>    <xsl:value-of select="$POSLogTime"/>\n</Data>
    </PrintNormal>

    <!-- テーブル番号を印刷 -->
    <PrintNormal>
      <Station>Receipt</Station>
      <Data>\u001b|rvC調理単品\u001b|N【<xsl:value-of select="//ixr:CODVoucherNumber"/>】\u001b|4C      <xsl:value-of select="$TableID"/>\u001b|N\n</Data>
    </PrintNormal>

	<!-- セレクトメニュー -->
    <xsl:apply-templates select="ixr:Sale/ixr:Combo/ixr:Member/ixr:Sale"/>

    <!-- 商品数量を取得(2桁に成形) -->
    <xsl:variable name="Quantity" select="concat(substring('  ', 1, 2 - string-length(ixr:Quantity)), ixr:Sale/ixr:Quantity)"/>
    <!-- 数量、商品名を印刷 -->
	<xsl:choose xml:space="default">
		<!-- 取り消しメニューの場合 -->
		<xsl:when test="@CancelFlag='true'" xml:space="preserve">
		<!-- 反転する -->
      <PrintNormal>
        <Station>Receipt</Station>
        <Data>        \u001b|4C\u001b|rvC-<xsl:value-of select="$Quantity"/>\u001b|N\u001b|3C    <xsl:value-of select="ixr:Sale/ixr:Description"/>\u001b|N\n</Data>
      </PrintNormal>
		</xsl:when>
		<!-- 通常メニューの場合 -->
		<xsl:otherwise xml:space="preserve">
      <PrintNormal>
        <Station>Receipt</Station>
        <Data>        \u001b|4C<xsl:value-of select="$Quantity"/>\u001b|N\u001b|3C    <xsl:value-of select="ixr:Sale/ixr:Description"/>\u001b|N\n</Data>
      </PrintNormal>
		</xsl:otherwise>
	</xsl:choose>

    <!-- 迂回情報の印刷 -->
    <PrintNormal>
      <Station>Receipt</Station>
      <Data>\n</Data>
    </PrintNormal>
    <PrintNormal>
      <Station>Receipt</Station>
      <Data>\u001b|cA\u001b|3C↓↓ プリンタ異常により迂回 ↓↓\u001b|N\n</Data>
    </PrintNormal>

    <!-- 伝票を20mmにするため、2mm(16ドット)の改行 -->

    <!-- 用紙カットコマンド使用(TM-T90 キッチン用プリンタ専用コマンド。このコマンド実行後
         112ドットフィードしたところでオートカッターが動作) -->
    <PrintNormal>
      <Station>Receipt</Station>
      <Data>\u001b|100fP</Data>
    </PrintNormal>

  </xsl:template>

  <!-- セレクトメニュー -->
  <xsl:template match="ixr:Combo/ixr:Member/ixr:Sale" xml:space="preserve">

    <!-- 商品数量を取得(2桁に成形) -->
    <xsl:variable name="Quantity" select="concat(substring('  ', 1, 2 - string-length(ixr:Quantity)), ixr:Quantity)"/>
    <!-- 数量、商品名を印刷 -->
	<xsl:choose xml:space="default">
		<!-- 取り消しメニューの場合 -->
		<xsl:when test="//ixr:LineItem/@CancelFlag='true'" xml:space="preserve">
		<!-- 反転する -->
      <PrintNormal>
        <Station>Receipt</Station>
        <Data>          \u001b|rvC-<xsl:value-of select="$Quantity"/>\u001b|N      <xsl:value-of select="ixr:Description"/>\n</Data>
      </PrintNormal>
		</xsl:when>
		<!-- 通常メニューの場合 -->
		<xsl:otherwise xml:space="preserve">
      <PrintNormal>
        <Station>Receipt</Station>
        <Data>          <xsl:value-of select="$Quantity"/>      <xsl:value-of select="ixr:Description"/>\n</Data>
      </PrintNormal>
		</xsl:otherwise>
	</xsl:choose>

  </xsl:template>

</xsl:stylesheet>
