﻿<?xml version="1.0" encoding="UTF-8"?>

<!-- スタッフコール -->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns="http://www.nrf-arts.org/UnifiedPOS/POSPrinter/" xmlns:ofsc="http://www.ofsc.org/namespace/Device/2008/11" xmlns:ixr="http://www.nrf-arts.org/IXRetail/namespace/" version="1.0">
  <xsl:output method="xml" encoding="utf-8"/>

  <xsl:template match="/">
    <s:Envelope xmlns:s="http://schemas.xmlsoap.org/soap/envelope/">
      <s:Body>
        <POSPrinter MajorVersion="1">
          <ARTSHeader>
            <MessageID/>
          </ARTSHeader>
          <POSPrinterBody>
          <xsl:apply-templates select=".//ixr:POSLog"/>
          </POSPrinterBody>
        </POSPrinter>
      </s:Body>
    </s:Envelope>
  </xsl:template>

  <xsl:template match="ixr:POSLog" xml:space="preserve">

    <!-- 初期設定 -->
    <Open/>
    <Claim>
      <Timeout>3000</Timeout>
    </Claim>
    <SetDeviceEnabled>
      <DeviceEnabled>true</DeviceEnabled>
    </SetDeviceEnabled>
    <SetMapMode>
      <MapMode>Dots</MapMode>
    </SetMapMode>
    <SetRecLetterQuality>
      <RecLetterQuality>true</RecLetterQuality>
    </SetRecLetterQuality>
    <TransactionPrint>
      <Station>Receipt</Station>
      <Control>Transaction</Control>
    </TransactionPrint>

    <!-- 180度回転モードの設定 -->
    <RotatePrint>
      <Station>Receipt</Station>
      <Rotation>259</Rotation>
    </RotatePrint>

    <!-- 白伝用 カットコマンド -->
    <PrintNormal>
      <Station>Receipt</Station>
      <Data>\u001b|100fP</Data>
    </PrintNormal>

    <!-- 印刷データ作成 -->
    <xsl:apply-templates select="ixr:Transaction"/>

    <!-- 最後のカットを実行するため112ドットフィード。
         また視認性向上のため、80ドット(10mm)フィード -->

    <!-- 180度回転モード終了 -->
    <RotatePrint>
      <Station>Receipt</Station>
      <Rotation>1</Rotation>
    </RotatePrint>

    <!-- ブザー鳴呼 -->

    <TransactionPrint>
      <Station>Receipt</Station>
      <Control>Normal</Control>
    </TransactionPrint>
    <SetDeviceEnabled>
      <DeviceEnabled>false</DeviceEnabled>
    </SetDeviceEnabled>
    <Release/>
    <Close/>

  </xsl:template>

  <!-- Transaction -->
  <xsl:template match="ixr:Transaction" xml:space="preserve">
    <!-- 時間を取り出す -->
    <xsl:variable name="POSLogDateTime" select="//ixr:POSLogDateTime"/>
    <xsl:variable name="POSLogTime" select="substring($POSLogDateTime, 12, 5)"/>

    <!-- 180度回転で印刷するため、下のデータから指定していく -->

    <!-- 伝票を20mmにするため、2mm(16ドット)の改行 -->

    <!-- 横線 -->
    <PrintNormal>
      <Station>Receipt</Station>
      <Data>\u001b|cA------------------------------------------\u001b|N\n</Data>
    </PrintNormal>

    <xsl:apply-templates select="ixr:ReceiptImage"/>

    <!-- 横線 -->
    <PrintNormal>
      <Station>Receipt</Station>
      <Data>\u001b|cA------------------------------------------\u001b|N\n</Data>
    </PrintNormal>

    <!-- タイトル(スタッフコール : HH:MM) -->
    <PrintNormal>
      <Station>Receipt</Station>
      <Data> \u001b|cA\u001b|4Cスタッフコール <xsl:value-of select="$POSLogTime"/>\u001b|N\n</Data>
    </PrintNormal>

    <!-- 伝票を20mmにするため、2mm(16ドット)の改行 -->

    <!-- 用紙カットコマンド使用(TM-T90 キッチン用プリンタ専用コマンド。このコマンド実行後
         112ドットフィードしたところでオートカッターが動作) -->
    <PrintNormal>
      <Station>Receipt</Station>
      <Data>\u001b|100fP</Data>
    </PrintNormal>

  </xsl:template>


    <!-- ReceiptImage -->
    <xsl:template match="ixr:ReceiptImage" xml:space="preserve">
        <!-- 一行づつ印字だが、通常は一行のみのはず -->
        <xsl:for-each select="//ixr:ReceiptLine">
          <PrintNormal>
            <Station>Receipt</Station>
            <Data>\u001b|cA\u001b|4C<xsl:value-of select="."/> から呼出\u001b|N\n</Data>
          </PrintNormal>
        </xsl:for-each>
    </xsl:template>

</xsl:stylesheet>
