﻿<?xml version="1.0" encoding="UTF-8"?>

<!-- 調理指示 一枚伝票用-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns="http://www.nrf-arts.org/UnifiedPOS/POSPrinter/" xmlns:ofsc="http://www.ofsc.org/namespace/Device/2008/11" xmlns:ixr="http://www.nrf-arts.org/IXRetail/namespace/" version="1.0">
  <xsl:output method="xml" encoding="utf-8"/>

  <xsl:template match="/">
    <s:Envelope xmlns:s="http://schemas.xmlsoap.org/soap/envelope/">
      <s:Body>
        <POSPrinter MajorVersion="1">
          <ARTSHeader>
            <MessageID/>
          </ARTSHeader>
          <POSPrinterBody>
          <xsl:apply-templates select=".//ixr:POSLog"/>
          </POSPrinterBody>
        </POSPrinter>
      </s:Body>
    </s:Envelope>
  </xsl:template>

  <xsl:template match="ixr:POSLog" xml:space="preserve">

    <!-- 初期設定 -->
    <Open/>
    <Claim>
      <Timeout>3000</Timeout>
    </Claim>
    <SetDeviceEnabled>
      <DeviceEnabled>true</DeviceEnabled>
    </SetDeviceEnabled>
    <SetMapMode>
      <MapMode>Dots</MapMode>
    </SetMapMode>
    <SetRecLetterQuality>
      <RecLetterQuality>true</RecLetterQuality>
    </SetRecLetterQuality>
    <TransactionPrint>
      <Station>Receipt</Station>
      <Control>Transaction</Control>
    </TransactionPrint>

    <!-- 180度回転モードの設定 -->

    <!-- 白伝用 カットコマンド -->
    <PrintNormal>
      <Station>Receipt</Station>
      <Data>\u001b|100fP</Data>
    </PrintNormal>

    <!-- 印刷データ作成 -->
    <xsl:apply-templates select="ixr:Transaction"/>

    <!-- 180度回転モード終了 -->

    <!-- ブザー鳴呼 -->

    <TransactionPrint>
      <Station>Receipt</Station>
      <Control>Normal</Control>
    </TransactionPrint>
    <SetDeviceEnabled>
      <DeviceEnabled>false</DeviceEnabled>
    </SetDeviceEnabled>
    <Release/>
    <Close/>

  </xsl:template>

  <!-- Transaction -->
  <xsl:template match="ixr:Transaction" xml:space="preserve">
    <!-- シーケンス番号を5桁の文字列に成形 -->
    <xsl:variable name="SequenceNumber" select="format-number(ixr:SequenceNumber, '00000')"/>
    <!--  注文時間を抽出(5桁の文字列) -->
    <xsl:variable name="POSLogTime" select="substring(//ixr:POSLogDateTime, 12, 5)"/>
    <!-- テーブル番号を5桁の文字列に成形 -->
    <xsl:variable name="Temp1" select=".//ixr:TableID"/>
    <xsl:variable name="TableID" select="concat(substring('      ', 1, 5 - string-length($Temp1)), $Temp1)"/>
    <!-- 人数を12桁の文字列に成形 -->
    <xsl:variable name="Temp2" select=".//ixr:PartySize"/>
    <xsl:variable name="PartySize" select="concat(substring('            ', 1, 12 - string-length($Temp2)), $Temp2)"/>
    <!-- 担当者名を6桁(全角)の文字列に成形 -->
    <xsl:variable name="OperatorID" select="concat(substring('　　　　　　', 1, 6 - string-length(ixr:OperatorID)), ixr:OperatorID)"/>
    <!-- 端末番号を12桁の文字列に成形 -->
    <xsl:variable name="WorkstationID" select="concat(substring('            ', 1, 12 - string-length(ixr:WorkstationID)), ixr:WorkstationID)"/>

    <!-- タイトルの印刷 -->
    <PrintNormal>
      <Station>Receipt</Station>
      <Data>\u001b|rvC調理一枚\u001b|N  【<xsl:value-of select=".//ixr:CODVoucherNumber"/>】\n</Data>
    </PrintNormal>

    <!-- テーブル番号、シーケンス番号の印刷 -->
    <PrintNormal>
      <Station>Receipt</Station>
      <Data>テーブル  \u001b|2C<xsl:value-of select="$TableID"/>\u001b|N  伝　　票\u001b|2C  <xsl:value-of select="$SequenceNumber"/>\u001b|N\n</Data>
    </PrintNormal>

    <!-- 人数、担当者名の印刷 -->
    <PrintNormal>
      <Station>Receipt</Station>
      <Data>人　　数<xsl:value-of select="$PartySize"/>  担　　当  <xsl:value-of select="$OperatorID"/>\n</Data>
    </PrintNormal>

    <!-- 時間、端末番号の印刷 -->
    <PrintNormal>
      <Station>Receipt</Station>
      <Data>時　　刻       <xsl:value-of select="$POSLogTime"/>  ＨＴ番号  <xsl:value-of select="$WorkstationID"/>\n</Data>
    </PrintNormal>

    <!-- 商品情報の印刷 -->
    <xsl:apply-templates select="ixr:CustomerOrderTransaction"/>

    <!-- 用紙カット -->
    <PrintNormal>
      <Station>Receipt</Station>
      <Data>\u001b|100fP</Data>
    </PrintNormal>

  </xsl:template>

  <xsl:template match="ixr:CustomerOrderTransaction" xml:space="preserve">
    <!-- 罫線フォントを使用するため、改行量も文字の高さ(24ドット)に設定 -->
    <SetRecLineSpacing>
      <RecLineSpacing>24</RecLineSpacing>
    </SetRecLineSpacing>

    <PrintNormal>
      <Station>Receipt</Station>
      <Data>┏━┯━━┯━━━━━━━━━━━━━━━━━┓\n</Data>
    </PrintNormal>
    <PrintNormal>
      <Station>Receipt</Station>
      <Data>┃　│数量│　　　　　品　　　　　名　　　　　┃\n</Data>
    </PrintNormal>
    <PrintNormal>
      <Station>Receipt</Station>
      <Data>┠─┼──┼─────────────────┨\n</Data>
    </PrintNormal>

    <!-- 売り上げ商品情報を印刷 -->
    <xsl:apply-templates select="ixr:LineItem"/>

    <PrintNormal>
      <Station>Receipt</Station>
      <Data>\u001b|3C┃　│　　│　　　　　　　　　　　　　　　　　┃\u001b|N\n</Data>
    </PrintNormal>
    <PrintNormal>
      <Station>Receipt</Station>
      <Data>\u001b|3C┃　│　　│　　　　　　　　　　　　　　　　　┃\u001b|N\n</Data>
    </PrintNormal>
    <PrintNormal>
      <Station>Receipt</Station>
      <Data>┗━┷━━┷━━━━━━━━━━━━━━━━━┛\n</Data>
    </PrintNormal>

    <!-- 改行量をデフォルト(30ドット)に設定 -->
    <SetRecLineSpacing>
      <RecLineSpacing>30</RecLineSpacing>
    </SetRecLineSpacing>

  </xsl:template>

  <xsl:template match="ixr:LineItem" xml:space="preserve">
    <!-- 商品数量を取得(2桁に成形) -->
    <xsl:variable name="Quantity" select="concat(substring('  ', 1, 2 - string-length(ixr:Sale/ixr:Quantity)), ixr:Sale/ixr:Quantity)"/>
    <!--  商品名の半角を削除した(全角のみの)文字列を作成 -->
    <xsl:variable name="NonHalf" select="translate(ixr:Sale/ixr:Description,'ｱｲｳｴｵｶｷｸｹｺｻｼｽｾｿﾀﾁﾂﾃﾄﾅﾆﾇﾈﾉﾊﾋﾌﾍﾎﾏﾐﾑﾒﾓﾔﾕﾖﾗﾘﾙﾚﾛﾜｦﾝｧｨｩｪｫｯｭｮｰﾞﾟ･ABCDEFGHIJKLMNOPQRSTUVWXYZ()[]{} \#$-+/*_.@%0123456789','')"/>
    <!--  メニュー名領域幅-半角34文字分の文字列を作成 -->
    <xsl:variable name="MenuName" select="concat(ixr:Sale/ixr:Description, substring('                                  ',1,34-string-length($NonHalf)*2-(string-length(ixr:Sale/ixr:Description)-string-length($NonHalf))))"/>

	<xsl:choose xml:space="default">
		<!-- 取り消しメニューの場合 -->
		<xsl:when test="@CancelFlag='true'" xml:space="preserve">
		<!-- 反転する -->
      <!-- 数量を印刷 -->
      <!-- 商品名を印刷 -->
      <PrintNormal>
        <Station>Receipt</Station>
        <Data>\u001b|3C┃\u001b|N□\u001b|3C│\u001b|rvC -<xsl:value-of select="$Quantity"/>\u001b|N\u001b|3C│<xsl:value-of select="$MenuName"/>┃\u001b|N\n</Data>
      </PrintNormal>
		</xsl:when>
		<!-- 通常メニューの場合 -->
		<xsl:otherwise xml:space="preserve">
      <!-- 数量を印刷 -->
      <!-- 商品名を印刷 -->
      <PrintNormal>
        <Station>Receipt</Station>
        <Data>\u001b|3C┃\u001b|N□\u001b|3C│\u001b|4C<xsl:value-of select="$Quantity"/>\u001b|3C│<xsl:value-of select="$MenuName"/>┃\u001b|N\n</Data>
      </PrintNormal>
		</xsl:otherwise>
	</xsl:choose>

	<!-- セレクトメニュー -->
    <xsl:apply-templates select="ixr:Sale/ixr:Combo/ixr:Member/ixr:Sale"/>

  </xsl:template>


  <!-- セレクトメニュー -->
  <xsl:template match="ixr:Sale/ixr:Combo/ixr:Member/ixr:Sale" xml:space="preserve">
    <!-- 商品数量を取得(2桁に成形) -->
    <xsl:variable name="Quantity" select="concat(substring('  ', 1, 2 - string-length(ixr:Quantity)), ixr:Quantity)"/>
    <!--  商品名の半角を削除した(全角のみの)文字列を作成 -->
    <xsl:variable name="NonHalf" select="translate(ixr:Description,'ｱｲｳｴｵｶｷｸｹｺｻｼｽｾｿﾀﾁﾂﾃﾄﾅﾆﾇﾈﾉﾊﾋﾌﾍﾎﾏﾐﾑﾒﾓﾔﾕﾖﾗﾘﾙﾚﾛﾜｦﾝｧｨｩｪｫｯｭｮｰﾞﾟ･ABCDEFGHIJKLMNOPQRSTUVWXYZ()[]{} \#$-+/*_.@%0123456789','')"/>
    <!--  メニュー名領域幅-半角32文字分の文字列を作成(セレクトサブメニューは半角2文字分インデントする) -->
    <xsl:variable name="MenuName" select="concat(ixr:Description, substring('                                  ',1,32-string-length($NonHalf)*2-(string-length(ixr:Description)-string-length($NonHalf))))"/>


	<xsl:choose xml:space="default">
		<!-- 取り消しメニューの場合 -->
		<xsl:when test="//ixr:LineItem/@CancelFlag='true'" xml:space="preserve">
		<!-- 反転する -->
      <!-- 数量、商品名を印刷 -->
   	  <!-- サブメニューの場合 インデントを全角１つ入れる-->
      <PrintNormal>
        <Station>Receipt</Station>
        <Data>\u001b|3C┃\u001b|N  \u001b|3C│\u001b|rvC -<xsl:value-of select="$Quantity"/>\u001b|N\u001b|3C│　<xsl:value-of select="$MenuName"/>┃\u001b|N\n</Data>
      </PrintNormal>
		</xsl:when>
		<!-- 通常メニューの場合 -->
		<xsl:otherwise xml:space="preserve">
    <!-- 数量、商品名を印刷 -->
 	  <!-- サブメニューの場合 インデントを全角１つ入れる-->
      <PrintNormal>
        <Station>Receipt</Station>
        <Data>\u001b|3C┃\u001b|N  \u001b|3C│  <xsl:value-of select="$Quantity"/>│　<xsl:value-of select="$MenuName"/>┃\u001b|N\n</Data>
      </PrintNormal>
		</xsl:otherwise>
  </xsl:choose>

  </xsl:template>

</xsl:stylesheet>
